# -*- coding: utf-8 -*-

'''
**Exercice 4 - Mesure par aspect ondulatoire**

On mesure sur l’oscilloscope la période d’un des signaux. On trouve T = 24.4 μs. Le calibre choisi dans la base temporelle de l’oscilloscope permet une mesure précise à 0.1 μs près.

On en déduité u(T)= 0.06 μs

Question : Calculer la fréquence ν = 1/T correspondante du signal et, à l’aide d’une simulation Monte-Carlo, en déduire l’incertitude-type sur cette fréquence.
'''
import numpy as np
import matplotlib.pyplot as plt

# Entrez la période

T = 24.4e-6 # s

# Entrez la précision sur la période

DeltaT = 0.1e-6 # s

# Entrez la fonction de composition

def f(x):
    return 1/x

# Entrez le nombre de simulation que vous voulez effectuer 

N = 100000

# Calculs avec une distribution de probabilité uniforme
Periode = []
Frequence = []

for i in range(0,N):
    x = np.random.uniform(T-DeltaT,T+DeltaT)
    Periode.append(x)
    Frequence.append(f(x))

plt.figure(1)
plt.hist(Periode,bins = 'rice')  # La commande 'rice' permet d'optimiser les intervalles d'affichage de l'histogramme
plt.title('Tirage aléatoire des périodes')
plt.xlabel('Périodes (s)')

plt.figure(2)
plt.hist(Frequence,bins = 'rice')
plt.title('Résultat du tirage aléatoire des fréquences après calcul')
plt.xlabel('Fréquences (Hz)')

# Calcul et affichage moyenne et écart type

moy = np.mean(Frequence)
std = np.std(Frequence,ddof=1)

print("Moyenne = {:.2f} Hz".format(moy))
print("Ecart type = {:.2f} Hz".format(std))
